// aunzip.h
//
// C/C++ header file for addUNZIP compression libraries
//
// Copyright  1995,1997 Stephen Darlington. All rights reserved.
//

#ifndef _ADDUNZIP_H_
#define _ADDUNZIP_H_

typedef unsigned char BYTE;
typedef unsigned short UINT16;
typedef unsigned long UINT32;
typedef char CHAR;
typedef short INT16;
typedef long INT32;

typedef INT16 (CALLBACK *CALLBACKFN)(INT16, INT16, LPSTR);

// function prototypes
#ifdef __cplusplus
extern "C"
{
#endif

INT32 CALLBACK _export addUNZIP(void);
INT16 CALLBACK _export addUNZIP_ArchiveName(LPSTR filename);
INT16 CALLBACK _export addUNZIP_Decrypt(LPSTR cPassword);
INT16 CALLBACK _export addUNZIP_DisplayComment(INT16 bFlag);
INT16 CALLBACK _export addUNZIP_Exclude(LPSTR files);
INT16 CALLBACK _export addUNZIP_ExcludeListFile(LPSTR cFile);
INT16 CALLBACK _export addUNZIP_ExtractTo(LPSTR cPath);
INT16 CALLBACK _export addUNZIP_Freshen(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_GetLastError(void);
INT16 CALLBACK _export addUNZIP_GetLastWarning(void);
INT16 CALLBACK _export addUNZIP_Include(LPSTR files);
INT16 CALLBACK _export addUNZIP_IncludeListFile(LPSTR cFile);
INT16 CALLBACK _export addUNZIP_InstallCallback(CALLBACKFN fn);
INT16 CALLBACK _export addUNZIP_Overwrite(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_Register(LPSTR cName, UINT32 iNumber);
void  CALLBACK _export addUNZIP_ResetDefaults(void);
INT16 CALLBACK _export addUNZIP_RestoreAttributes(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_RestoreStructure(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_SetParentWindowHandle(HWND hwnd);
INT16 CALLBACK _export addUNZIP_SetWindowHandle(HWND hwnd);
INT16 CALLBACK _export addUNZIP_Test(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_ToMemory(LPSTR, UINT32);
INT16 CALLBACK _export addUNZIP_ToPrinter(LPSTR szPort);
INT16 CALLBACK _export addUNZIP_Update(INT16 iFlag);
INT16 CALLBACK _export addUNZIP_View(INT16 bFlag);

// constants for addUNZIP_Overwrite(...)
#define azOVERWRITE_QUERY 0x0a
#define azOVERWRITE_ALL   0x0b
#define azOVERWRITE_NONE  0x0c

// constants used in messages
#define azLIBRARY_ADDUNZIP 1

// constants for addUNZIP_RestoreAttributes(...)
#define azATTR_NONE 0
#define azATTR_READONLY 1
#define azATTR_HIDDEN 2
#define azATTR_SYSTEM 4
#define azATTR_ARCHIVE 32
#define azATTR_ALL 39

// addZIP & addUNZIP messages
#define AM_SEARCHING      0x0a
#define AM_ZIPCOMMENT     0x0b
#define AM_ZIPPING        0x0c
#define AM_ZIPPED         0x0d
#define AM_UNZIPPING      0x0e
#define AM_UNZIPPED       0x0f
#define AM_TESTING        0x10
#define AM_TESTED         0x11
#define AM_DELETING       0x12
#define AM_DELETED        0x13
#define AM_DISKCHANGE     0x14
#define AM_VIEW           0x15
#define AM_ERROR          0x16
#define AM_WARNING        0x17
#define AM_QUERYOVERWRITE 0x18
#define AM_COPYING        0x19
#define AM_COPIED         0x1a
//#define AM_REPAIRING      0x1b
//#define AM_FILECOMMENT    0x1c
//#define AM_PASSWORD       0x1d
#define AM_ABORT          0xff

// Constants for compression method in AM_VIEW
#define azCM_NONE 0              0x00
#define azCM_SHRUNK              0x0a
#define azCM_REDUCED_1           0x14
#define azCM_REDUCED_2           0x1e
#define azCM_REDUCED_3           0x28
#define azCM_REDUCED_4           0x32
#define azCM_IMPLODED            0x3c
#define azCM_TOKENISED           0x46
#define azCM_DEFLATED_NORMAL     0x50
#define azCM_DEFLATED_MAXIMUM    0x51
#define azCM_DEFLATED_FAST       0x52
#define azCM_DEFLATED_SUPERFAST  0x53
#define azCM_UNKNOWN             0xff

//Constants for whether file is encrypted or not in AM_VIEW
#define azFT_NOT_ENCRYPTED 0x00
#define azFT_ENCRYPTED     0x01

//Constants for whether file is text or binary in AM_VIEW
#define azFT_TEXT   0x00
#define azFT_BINARY 0x01

// Constants used in returning from a AM_QUERYOVERWRITE message
#define azOW_YES        0x00
#define azOW_YES_TO_ALL 0x01
#define azOW_NO         0x02
#define azOW_NO_TO_ALL  0x03

#ifdef __cplusplus
}
#endif
#endif
